// NO_VARIATIONS  <= this is a hint to the FX compiler, don't delete it

struct VS_OUTPUT {
    float4 position   : POSITION;
    float2 uv         : TEXCOORD0;
    float2 uv2        : TEXCOORD1;
    float2 uv3        : TEXCOORD2;
};

float4x4 object_to_proj_matrix;

texture diffuse_texture;

// main screen data
sampler DiffuseTextureSampler = 
sampler_state {
    Texture = <diffuse_texture>;    
    MipFilter = NONE;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

float4 texel_size;

struct PS_OUTPUT {
    float4 color : COLOR0;  // Pixel color    
};

VS_OUTPUT vertex_shader(float4 input_position : POSITION, 
                        float2 uv: TEXCOORD0,
                        float2 uv2: TEXCOORD1,
                        float2 uv3: TEXCOORD2) {
    VS_OUTPUT output;
    output.position = mul(input_position, object_to_proj_matrix);
    output.uv = uv;
    output.uv2 = uv + texel_size * float2(1,0);
    output.uv3 = uv + texel_size * float2(0,1);
    return output;
}

PS_OUTPUT pixel_shader(VS_OUTPUT input)
{
	PS_OUTPUT output;
	float s00 = tex2D(DiffuseTextureSampler, input.uv);
	float s01 = tex2D(DiffuseTextureSampler, input.uv2);
	float s10 = tex2D(DiffuseTextureSampler, input.uv3);
	
	float2 delta = { s01-s00, s10-s00 };
	float d = 1.0 / sqrt(delta.x * delta.x + delta.y * delta.y);
	delta *= d;
	output.color.r = sqrt(s00); // make gaussian more linear (in 0 .. 0.5 region)
	output.color.g = (delta.x+1)/2;
	output.color.b = (delta.y+1)/2;
	output.color.a = 0;
    return output;
}

technique render {
    pass P0 {
        VertexShader = compile vs_1_1 vertex_shader();
        PixelShader  = compile ps_2_0 pixel_shader();

        AlphaBlendEnable = False;
        AlphaTestEnable = False;

        CullMode = CW;  // allow mesh to invert and see what that looks like... answer: lame
        ZEnable = False;
        ZWriteEnable = False;
    }
}
